;**************************************************************
;      mega8.
;   ,    32768 ,   4 
;  ( , ,   ,     
;   
;   -  
;pb5 -      1  6    
;pb4 -   : (  ), (  ),  ,   ,     
;-    ,      
;pb3 -   : (  ), (),  .,  .,   .
;-    ,      
;           
;
;   
; 1 -   
; 2 -  
; 3 -     1  - 4 
; 4 -          (1-50 )
; 5 -     (0-256),       ,      (      
;      ),      
; 6 -   :
;
;0 -      -  
;1 -      
;2 -  2       2
;3 -  3     2   3
;4 -  4     3   4
;5 -  5     4   5
;6 -  6     5   6
;
; save -   

;http://bretmulvey.com/avrdelay.html
;*************************************************

;=================================================
.include "m8def.inc"

; 
.def	zero	= r1	;0
.def	byte_0	= r2
.def	byte_1	= r3
.def	byte_2	= r4
.def	bin_h	= r5
.def	bin_l	= r6
.def switch_adc   = r11	;  sleep    
;===========================================================================

.def temp = r16
.def bitmap = r16	; ,   
;0 -   (1)
;1 -   (1)
;7 -   (0)

.def temp1 = r17	; 
.def temp2 = r18	; 

.def cnt = r19		;  
.def smdl = r20		;  

.def lcd =   r22	; 
.def count = r23	; ,  

.def hex_01 = r24	;     
.def hex_02 = r25
.def hex_03 = r26

.def temp_hex_01 = r27	;      
.def temp_hex_02 = r28
.def temp_hex_03 = r29

;====================================================
.equ	XTAL		= 4000000
;====================================================
.equ	t_count		= 1000000/(XTAL/768)
.equ	t_smdl		= 100000000/(XTAL/3)
.equ	t_480h		= 480/t_count+1
.equ	t_480l		= 100*(480-(t_480h-1)*t_count)/t_smdl
.equ	t_70h		= 70/t_count+1
.equ	t_70l		= 100*(70-(t_70h-1)*t_count)/t_smdl
.equ	t_410h		= 410/t_count+1
.equ	t_410l		= 100*(410-(t_410h-1)*t_count)/t_smdl
.equ	t_55h		= 55/t_count+1
.equ	t_55l		= 100*(55-(t_55h-1)*t_count)/t_smdl
.equ	t_60h		= 60/t_count+1
.equ	t_60l		= 100*(60-(t_60h-1)*t_count)/t_smdl
.equ	t_64h		= 64/t_count+1
.equ	t_64l		= 100*(64-(t_64h-1)*t_count)/t_smdl
.equ	t_6		= 600/t_smdl
.equ	t_9		= 900/t_smdl
.equ	t_10		= 1000/t_smdl
;====================================================
.equ	t_ctc		= (XTAL/1024)*100/133
;====================================================
.equ	t_port		= PORTC
.equ	t_ddr		= DDRC
.equ	t_pin		= PINC
.equ	t_sens		= 0
;****************************************************
.equ RS=4	; 
.equ E=5


;  SRAM 
.DSEG
;    
clock_alarm:	.byte	3	;     HEX
on_minute:	.byte	3	;     HEX 
degADC:		.byte	1	;    
day:		.byte	1	; (,  ,  2    )
alarm_off:	.byte	3	;     HEX
temper_cp:	.byte	1	;      
temper_heart:	.byte	1	;       (   )
setup:		.byte	1	;1 -   
;==============================================================================================

alarm_active:	.byte	1	;   , 0-, 1-

clock_day:	.byte	3	;      HEX 

time:		.byte	6	;   HEX 
alarm:		.byte	6	;   ascii 
timer:		.byte	6	;   ascii 

hours:		.byte	1	;     
minutes:	.byte	1	;     
seconds:	.byte	1

hours_alarm:	.byte	1	;     
minutes_alarm:	.byte	1	;       
seconds_alarm:	.byte	1

hours_timer:	.byte	1	;     
minutes_timer:	.byte	1	;       
seconds_timer:	.byte	1

menu_num:	.byte	1	; ,     =0
menu_fact:	.byte	1	;   ,     =0,   
menu_fact_set:	.byte	1	;  0 -    
menu_fact2:	.byte	1	;  0 -     

degH:		.byte	1	;   8 
ADC_display:	.byte	3	;         
ADC_displaySet:	.byte	3	;       

t_data:		.byte	2	;    
t_asc2:		.byte	10
t_bitmap:	.byte	1
chan_1:		.byte	4

temper_hex:	.byte	1	;      1  
temper:		.byte	2	;        ( )

timer_led:	.byte	1	;    
timer_led_on:	.byte	1	;    

day_count:	.byte	1	; ,       


.cseg

.org	$000
	rjmp main_program	;   
.org	OVF2addr
	rjmp clock		;  ,  
.org	OVF1addr
	rjmp check_keys		;    
.org	ADCCadDr
	rjmp Adc		;   - 
	
	
DcMatrix:
		; hgfedcba    hgfedcba
	.db 	0b00000101, 0b11011101	;0,1
	.db 	0b01000110, 0b01010100	;2,3
	.db 	0b10011100, 0b00110100	;4,5(s)
	.db 	0b00100100, 0b01011101	;6,7
	.db 	0b00000100, 0b00010100	;8,9
	.db	0b11111111, 0b00001100	; ,a	10, 11
	.db	0b10000101, 0b00100110	; v,e	12, 13
	.db	0b11111110, 0b00000000	; -,	14, 15

;**************************
; 
main_program:

; 

RAM_Flush:	ldi	ZL, low(ramend)		;     
		ldi	ZH, high(ramend)
		clr	temp			;  temp
Flush:		st 	-Z,temp			;  0   
		cpi	ZH,0			;   ?
		brne	Flush			; ?  !
 
		cpi	ZL,$60			;     ?
		brne	Flush			;        


	ldi temp,LOW(RAMEND)		;  
	out spl,temp			;  SRAM
	ldi temp,HIGH(RAMEND)		
	out sph,temp
	
	rcall ports_tuning	;  
	rcall adc_init		; ADC
	
	clr zero		;  
	
ldi temp, 1
sts timer_led_on, temp		;   =1,  
			
	rcall clock_convert_to_time  	;    
					
;**********************************************************************************************************
;    
	ldi temp1, low(setup)	;   68h
;	ldi temp2, high(setup)
	rcall EERead	;     
	cpi temp, 1
	breq setup_1
	rjmp setup_0
setup_1:		;  
	ldi ZL, low(setup)		;    
	ldi temp1, low(temper_cp)	;    
Flush3:	
	rcall EERead	;    0  
	dec temp1	;       1
	st -Z, temp	;        
	cpi ZL, low(clock_alarm)	;    ?
	brne	Flush3			; ?  !
	
	rcall alarm_convert_to_time  	;    
	rcall timer_convert_to_time  	;    
	rcall temper_convert	  	;   
	rcall adc_convert	;    

;**********************************************************************************************************
setup_0:			;   	
	rcall clocking		;      
	sei			;    
	

;*******************************************************************************
;  ,      	
non_ends:
	lds temp, timer_led_on	;  -    
	cpi temp, 0		;     
	breq non_ends		;     ,   30 

	lds temp, menu_num
	cpi temp, 0
	breq NO_menu_jmp
	cpi temp, 1
	breq YES_menu_1	; 
	cpi temp, 2
	breq YES_menu_2	; 
	cpi temp, 3
	breq YES_menu_3	; 
	cpi temp, 4
	breq YES_menu_4	; 
	cpi temp, 5
	breq YES_menu_5	; 
	cpi temp, 6
	breq YES_menu_6	;  
	cpi temp, 7
	breq YES_menu_7	; 
	rjmp non_ends

NO_menu_jmp:
	rjmp NO_menu	;     
	
YES_menu_1:
	lds temp, menu_fact_set
	cpi temp, 0
	brne display1
	rcall display_led_time_set_M	
	rjmp non_ends
display1:
	rcall display_led_time_set	
	rjmp non_ends
	
YES_menu_2:
	lds temp, menu_fact_set
	cpi temp, 0
	brne display2
	rcall display_led_alarm_set_M	
	rjmp non_ends
display2:
	rcall display_led_alarm_set	
	rjmp non_ends
	
YES_menu_3:
	lds temp, menu_fact_set
	cpi temp, 0
	brne display3
	rcall display_led_timer_set_M	
	rjmp non_ends
display3:
	rcall display_led_timer_set	
	rjmp non_ends
	
YES_menu_4:
	lds temp, menu_fact_set
	cpi temp, 0
	brne display4
	rcall display_led_temp_set_M	
	rjmp non_ends
display4:
	rcall display_led_temp_set	
	rjmp non_ends
	
YES_menu_5:
	lds temp, menu_fact_set
	cpi temp, 0
	brne display5
	rcall display_led_adc_set_M	
	rjmp non_ends
display5:
	rcall display_led_adc_set	
	rjmp non_ends
	
YES_menu_6:
	lds temp, menu_fact_set
	cpi temp, 0
	brne display6
	rcall display_led_day_M	
	rjmp non_ends
display6:
	rcall display_led_day_set	
	rjmp non_ends

YES_menu_7:
	rcall display_led_save	
	rjmp non_ends
	
NO_menu:
	lds temp, menu_fact
	cpi temp, 0
	breq out_time
	cpi temp, 1
	breq time_sec
	cpi temp, 2
	breq out_temp
	cpi temp, 3
	breq out_adc2
	cpi temp, 4
	breq out_day_day
	rjmp non_ends
	
time_sec:
	rcall display_time_sec
	rjmp non_ends
	
out_temp:
	rcall display_led_temp
	rjmp non_ends
	
out_adc2:
	rcall display_led_adc
	rjmp non_ends
	
out_day_day:
	rcall display_led_day_day	
	rjmp non_ends
	
;*************************************************
out_time:
	lds temp, menu_fact2
	cpi temp, 0
	breq out_time2
	cpi temp, 1
	breq time_alarm_set
	cpi temp, 2
	breq out_timer_set
	cpi temp, 3
	breq out_temp_set
	cpi temp, 4
	breq out_adc_set
	cpi temp, 5
	breq out_day_set
	rjmp non_ends

out_time2:
	rcall display_led_time
	rjmp non_ends
	
time_alarm_set:
	rcall display_led_alarm_set
	rjmp non_ends
	
out_timer_set:
	rcall display_led_timer_set	
	rjmp non_ends
	
out_temp_set:
	rcall display_led_temp_set	
	rjmp non_ends
	
out_adc_set:
	rcall display_led_adc_set	
	rjmp non_ends
	
out_day_set:
	rcall display_led_day_set	
	rjmp non_ends
		
	

;*************************************************************************************

Adc:
	push temp
	in temp,sreg
	push temp
	push temp1		;   
	
;	ldi temp, (0<<adie)	; 
;	out adcsr, temp		;      

	cbi adcsr,adie		;      
				;   
	in temp, adch		;  8 ,    
	sts degH, temp		;     
;**************************************************************	
	lds temp, menu_num
	cpi temp,0		;    ,  0        
	brne out_adc		;   ,      
	
	rcall adc_convert2	;    
out_adc:	
	ldi temp,0		;         
	mov switch_adc,temp
	
	ldi temp, (1<<toie1) | (1<<toie2)	;T1 and T2  -    
	out timsk,temp

	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
;*************************************************************************************
;    2,   .  
;   
clock:                
	push temp
	in temp,sreg
	push temp		;   
	push temp1
	   
	lds hex_01, clock_day	;        
	lds hex_02, clock_day+1
	lds hex_03, clock_day+2
           
	ldi temp_hex_01, 1	;   
	clr temp_hex_02	;0
	clr temp_hex_03	;0
           
	add hex_01, temp_hex_01	;     1 
	adc hex_02, temp_hex_02
	adc hex_03, temp_hex_03
	
;****************************************************
;     
lds temp, timer_led_on
cpi temp, 1
breq on_timer_led
rjmp off_timer_led
on_timer_led:
lds temp, timer_led
inc temp
cpi temp, 180		;     180 
breq work_off
sts timer_led, temp
rjmp off_timer_led
work_off:
clr temp
sts timer_led_on, temp	;        

off_timer_led: 
	rcall check_time		;,      ,    
	rcall alarm_clock		;,    
           
	rcall clock_convert_to_time  	;    
	
;*****************************************************************************
;      	
	ldi temp,1
	mov switch_adc, temp	;1 -         
	
	ldi temp, (0<<toie1) | (1<<toie2)	;      2
	out timsk,temp 
	
	ldi temp,0b11001111		;  
	out adcsr,temp
	sei
	
	;     :
	; ADEN = 1 -  
	; ADSC = 1   (,  )
	; ADFR = 0     , 1 -   (6  )
	; ADIE = 1  . 
	; ADPS2..0 = 7    128 -      .

Loop:			;    
	cpse switch_adc, zero
	rjmp Loop

;********************************************************************************************
;  
	lds temp, time+5
	cpi temp, 1	; 1      
	breq call_dss
	cpi temp, 2	; 2       
	breq call_read
	rjmp exit_dss	;      
call_dss:
	sbi portb, 0	;    ( )
	rcall dss1
	rjmp exit_dss
call_read:
	cbi portb, 0	;    ( )
	rcall dss2	
	rcall bcd_convert
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
	ldi temp, $30		;  ascii  HEX 
	sub r9, temp		;     0,   0
	sub r10, temp		;   0,      HEX 
	ldi temp, $20
	cp r8, temp
	breq nul_r8
	ldi temp, $30
	sub r8, temp
	rjmp save_rom
	
nul_r8:
	clr r8
save_rom:	
	sts chan_1,r7		; +  -
	sts chan_1+1,r8		; 
	sts chan_1+2,r9		; 
	sts chan_1+3,r10	;  
	rcall convertK	;   
;------------------------------------------------------------------------------------------------
;       
	lds hex_01, temper_cp		;  
	lds temp_hex_01,temper_hex	;  
	sub temp_hex_01, hex_01		;  
	brsh ten_OFF		;    ,   
	rjmp ten_ON		; ,  
ten_OFF:
	ldi temp,$2d	; "-"    
	cp r7,temp	;       
	breq ten_ON
	
	cbi portb, 2	; 
;	rjmp heater	;      
	rjmp exit_dss	;   ,        
		
ten_ON:
	sbi portb, 2	; 

;+++++++++++++++++++++++++++++++++++++++++++++++++++++
;   
;heater:
;	ldi temp, 10			;   10 
;	lds temp_hex_01,temper_hex	;  
;	sub temp_hex_01, temp		;    - 
;	brlo heat_ON			;    ,   
;	rjmp heat_OFF
;heat_ON:
;	sbi portb, 0	; 
;	rjmp exit_dss
;heat_OFF:
;	cbi portb, 0	; 		
	
;***********************************************************************************************
exit_dss:
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
           
;**************************
;   
;**************************
check_keys:
	push temp
	in temp,sreg
	push temp		;   
	push temp1
	
	ldi temp,high($ffff - 6250);    6250 (   5 )
	out tcnt1h,temp
	ldi temp,low($ffff - 6250)
	out tcnt1l,temp
	
key1:	
	sbic 	PINB,3		;   it_is_hours ?
	rjmp 	key2		;  ,    
	rjmp	plus
key2:
	sbic 	PINB,4		;   it_is_minutes ?
	rjmp	key3		;  ,    
	rjmp	minus
key3:
	sbic 	PINB,5		;   menu ?
	rjmp	exit_scan	;  ,  
	rjmp	menu

exit_scan:			;     ,    
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  

;**************************************************************************************************
plus:
	lds temp, timer_led_on	;        
	cpi temp, 0		;  
	breq menu_zero		; ,           
	rjmp next_plus
	
menu_zero:
	clr temp
	sts menu_num, temp	;  
	sts menu_fact, temp	;
	ldi temp, $ff		;256
	sts menu_fact2, temp
	
next_plus:	
	ldi temp, 1
	sts timer_led_on, temp	;    
	sts timer_led, zero	;  
	
	lds temp, menu_num	;     ?
	cpi temp,1		; 1,   
	breq tune_hours1
	cpi temp,2		; 2,   
	breq tune_hours11
	cpi temp,3		; 3,   
	breq tune_hours111
	cpi temp,4		; 4,   
	breq tune_temp_m
	cpi temp,5		; 5,   
	breq tune_adc_m
	cpi temp,6		; 6,    
	breq jmp_tune_day_p
	
	lds temp, menu_fact2	;     (, , ,  ,   ,  )
	inc temp
	cpi temp, 6
	breq clr_menu_fact2
	sts menu_fact2, temp
	rjmp exit200
clr_menu_fact2:
	clr temp
	sts menu_fact2, temp

exit200:	

	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
jmp_tune_day_p:		;     
	rjmp tune_day_p

tune_hours1:
	rcall step_tune_clock_m		;    1 
	rcall check_time		;,      ,    
	rcall clock_convert_to_time  	;    
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_hours11:
	rcall step_tune_alarm_m		;    1 
	rcall check_alarm		;,      ,    
	rcall alarm_convert_to_time  	;    
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_hours111:
	rcall step_tune_timer_m		;    1 
	rcall check_timer		;        
	rcall timer_convert_to_time  	;    
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_temp_m:
	rcall step_tune_temper_m	;    1 
	rcall check_temper		;    (50 )
	rcall temper_convert	  	;   
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_adc_m:
	rcall step_tune_adc_m	;  
	rcall adc_convert	;    
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_day_p:
	rcall step_tune_day	;   
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
;*****************************************************************************************************
minus:
	lds temp, timer_led_on	;        
	cpi temp, 0		;  
	breq menu_zero1		; ,           
	rjmp next_minus
	
menu_zero1:
	clr temp
	sts menu_num, temp	;  
	sts menu_fact2, temp	;
	ldi temp, $ff		;256
	sts menu_fact, temp
	
next_minus:	
	ldi temp, 1
	sts timer_led_on, temp	;    
	sts timer_led, zero	;  
	
	lds temp, menu_num	;     ?
	cpi temp,1		; 1,   
	breq tune_hours2
	cpi temp,2		; 2,   
	breq tune_hours22
	cpi temp,3		; 3,   
	breq tune_hours222
	cpi temp,4		; 4,   
	breq tune_temp_h
	cpi temp,5		; 5,   
	breq tune_adc_h
	
	lds temp, menu_fact	;    (,    , ,  ,     )
	inc temp
	cpi temp, 5
	breq clr_menu_fact
	sts menu_fact, temp
	rjmp exit100
clr_menu_fact:
	clr temp
	sts menu_fact, temp

exit100:	
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  

tune_hours2:
	rcall step_tune_clock_h		;    1 
	rcall check_time		;,      ,    
	rcall clock_convert_to_time  	;    
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_hours22:
	rcall step_tune_alarm_h		;    1 
	rcall check_alarm		;,      ,    
	rcall alarm_convert_to_time  	;    
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_hours222:
	rcall step_tune_timer_h		;    10 
	rcall check_timer		;        
	rcall timer_convert_to_time  	;    
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_temp_h:
	rcall step_tune_temper_h	;    5 
	rcall check_temper		;    (50 )
	rcall temper_convert	  	;   
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  
        
tune_adc_h:
	rcall step_tune_adc_h	;  
	rcall adc_convert	;    
	ldi temp, 1
	sts menu_fact_set, temp
	pop temp1
	pop temp
        out sreg,temp
        pop temp	;   
        reti		;  

;*************
menu:
	lds temp, timer_led_on	;        
	cpi temp, 0		;  
	breq menu_zero2		; ,          
	rjmp next_menu
	
menu_zero2:
	ldi temp, 7
	sts menu_num, temp
	clr temp
	sts menu_fact, temp	;    
	sts menu_fact2, temp
	
next_menu:	
	ldi temp, 1
	sts timer_led_on, temp	;    
	sts timer_led, zero	;  
	
	lds temp, menu_num
	inc temp
	cpi temp, 8
	breq num_0_jmp	;  6 ,        0
	cpi temp,1
	breq menu_1	;    1
	cpi temp,2
	breq menu_2	;    2
	cpi temp,3
	breq menu_3	;    3
	cpi temp,4
	breq menu_4	;    4
	cpi temp,5
	breq menu_5	;    5
	cpi temp,6
	breq menu_6	;    6 (   )
	cpi temp,7
	breq num_7_jmp	;    7
	
num_7_jmp:		;     
	rjmp menu_7

num_0_jmp:		;     
	rjmp num_0	
menu_1:
	sts menu_num, temp	;    
	clr temp
	sts menu_fact_set, temp
	pop temp1
	pop temp
	out sreg, temp
	pop temp
	reti
	
menu_2:
	sts menu_num, temp	;    
	rcall alarm_convert_to_time
	clr temp
	sts menu_fact_set, temp
	pop temp1
	pop temp
	out sreg, temp
	pop temp
	reti
	
menu_3:
	sts menu_num, temp	;    
	rcall timer_convert_to_time
	clr temp
	sts menu_fact_set, temp
	pop temp1
	pop temp
	out sreg, temp
	pop temp
	reti
	
menu_4:
	sts menu_num, temp	;    
	rcall temper_convert	;   
	clr temp
	sts menu_fact_set, temp
	pop temp1
	pop temp
	out sreg, temp
	pop temp
	reti
	
menu_5:
	sts menu_num, temp	;    
	rcall adc_convert	;    
	clr temp
	sts menu_fact_set, temp
	pop temp1
	pop temp
	out sreg, temp
	pop temp
	reti
	
menu_6:
	sts menu_num, temp	;    
	clr temp
	sts menu_fact_set, temp
	pop temp1
	pop temp
	out sreg, temp
	pop temp
	reti
	
menu_7:
	sts menu_num, temp	;    
	rcall save_eep		;   
	clr temp
	sts menu_fact_set, temp
	pop temp1
	pop temp
	out sreg, temp
	pop temp
	reti
	
num_0:
	clr temp
	sts menu_num, temp	;   
	clr temp
	sts menu_fact_set, temp
	pop temp1
	pop temp
	out sreg, temp
	pop temp
	reti

;***********************************************************************************
;    
clocking:  
	ldi temp,high($ffff - 6250);    6250 (   5 )
	out tcnt1h,temp
	ldi temp,low($ffff - 6250)
	out tcnt1l,temp
           
	ldi temp,$05		;   - 128
	out tccr2,temp		;T2
	out tcnt2, zero		;   0
	ldi temp, 1<<AS2	;     2
	out assr, temp
	
	ldi temp,$04		; 
	out tccr1b,temp		; 256 +   1
           
	ldi temp, (1<<toie1) | (1<<toie2)	;T1, 2 -   
	out timsk,temp				;     

	ret	;  
	
;-----------------------------------------------------------------------------
;       

clock_convert_to_time:
	ldi temp_hex_01, $10	;3600   1 
	ldi temp_hex_02, $0e
	ldi temp_hex_03, $00
	
	lds hex_01, clock_day	;        
	lds hex_02, clock_day+1
	lds hex_03, clock_day+2
	
	rcall delen		;  
	sts  hours, count	;    
	
	ldi temp_hex_01, 60	;60   1 
	ldi temp_hex_02, $00
	ldi temp_hex_03, $00
	
	rcall delen		;  
	sts  minutes, count	;    
	sts seconds, hex_01	;    
	
;***************************************
	lds hex_01, hours	; 
	ldi temp_hex_01, 10
	rcall delen2
	sts time, count
	sts time+1, hex_01	;       ascii 
	
	lds hex_01, minutes	; 
	ldi temp_hex_01, 10
	rcall delen2
	sts time+2, count
	sts time+3, hex_01	;       ascii 
	
	lds hex_01, seconds	; 
	ldi temp_hex_01, 10	
	rcall delen2
	sts time+4, count
	sts time+5, hex_01	;       ascii 
ret

alarm_convert_to_time:
	ldi temp_hex_01, $10		;3600   1 
	ldi temp_hex_02, $0e
	ldi temp_hex_03, $00
	
	lds hex_01, clock_alarm		;        
	lds hex_02, clock_alarm+1
	lds hex_03, clock_alarm+2
	
	rcall delen			;  
	sts  hours_alarm, count		;    
	
	ldi temp_hex_01, 60		;60   1 
	ldi temp_hex_02, $00
	ldi temp_hex_03, $00
	
	rcall delen			;  
	sts  minutes_alarm, count	;    
	sts seconds_alarm, hex_01	;    
	
;***************************************
	lds hex_01, hours_alarm	; 
	ldi temp_hex_01, 10
	rcall delen2
	sts alarm, count
	sts alarm+1, hex_01	;       ascii 
	
	lds hex_01, minutes_alarm	; 
	ldi temp_hex_01, 10
	rcall delen2
	sts alarm+2, count
	sts alarm+3, hex_01	;       ascii 
	
	lds hex_01, seconds_alarm	; 
	ldi temp_hex_01, 10	
	rcall delen2
	sts alarm+4, count
	sts alarm+5, hex_01	;       ascii 
ret

timer_convert_to_time:
	ldi temp_hex_01, $10		;3600   1 
	ldi temp_hex_02, $0e
	ldi temp_hex_03, $00
	
	lds hex_01, on_minute		;        
	lds hex_02, on_minute+1
	lds hex_03, on_minute+2
	
	rcall delen			;  
	sts  hours_timer, count		;    
	
	ldi temp_hex_01, 60		;60   1 
	ldi temp_hex_02, $00
	ldi temp_hex_03, $00
	
	rcall delen			;  
	sts  minutes_timer, count	;    
	sts seconds_timer, hex_01	;    
	
;***************************************
	lds hex_01, hours_timer	; 
	ldi temp_hex_01, 10
	rcall delen2
	sts timer, count
	sts timer+1, hex_01	;       ascii 
	
	lds hex_01, minutes_timer	; 
	ldi temp_hex_01, 10
	rcall delen2
	sts timer+2, count
	sts timer+3, hex_01	;       ascii 
	
	lds hex_01, seconds_timer	; 
	ldi temp_hex_01, 10	
	rcall delen2
	sts timer+4, count
	sts timer+5, hex_01	;       ascii 
ret

temper_convert:
	ldi temp_hex_01, 10
	lds hex_01, temper_cp
	rcall delen2
	sts temper, count
	sts temper+1, hex_01
ret

adc_convert:
	ldi temp_hex_01, 100
	lds hex_01, degADC
	rcall delen2
	sts ADC_displaySet, count
	ldi temp_hex_01, 10
	rcall delen2
	sts ADC_displaySet+1, count
	sts ADC_displaySet+2, hex_01
	ret

adc_convert2:
	ldi temp_hex_01, 100
	lds hex_01, degH
	rcall delen2
	sts ADC_display, count
	ldi temp_hex_01, 10
	rcall delen2
	sts ADC_display+1, count
	sts ADC_display+2, hex_01
	ret
	
day_convert:
	ret

;-----------------------------------------------------------------------------
;     
ports_tuning:
	ldi temp, 0b00000111		;  B  
	out ddrb, temp
	sbi portb,3			;  PULLUP's
        sbi portb,4			; 
        sbi portb,5			;PB3, PB4, PB5
	
	ldi temp, 0b00111100		;  C
	out ddrc, temp			;  PC2, PC3, PC4, PC5
	ldi temp, 0b11111111		;  D  
	out ddrd, temp
	ret
	
;********************************************************************************
;  - 

adc_init:
	ldi	temp,0b00100001
	out	ADMUX,temp
	;      
	;REFS -- 0b[00]000101    -   
	;ADLAR --0b01[1]00101     
	;8-    ADCH
	;MUX -- 0b0100[0001]      ADC1
	ret


;************************************************************************************************************************************************************************
;       
alarm_clock:
	lds hex_01, clock_day		;        
	lds hex_02, clock_day+1
	lds hex_03, clock_day+2
	
	lds temp_hex_01, clock_alarm	;     
	lds temp_hex_02, clock_alarm+1
	lds temp_hex_03, clock_alarm+2
	
	sub hex_01, temp_hex_01		;      
	sbc hex_02, temp_hex_02
	sbc hex_03, temp_hex_03
	brlo alarm_NOT_0		;   (  )
alarm_YES:				;     
	lds hex_01, clock_day		;        
	lds hex_02, clock_day+1
	lds hex_03, clock_day+2
		
	lds temp_hex_01, alarm_off	;     
	lds temp_hex_02, alarm_off+1
	lds temp_hex_03, alarm_off+2
	
	sub hex_01, temp_hex_01		;      
	sbc hex_02, temp_hex_02
	sbc hex_03, temp_hex_03
	brlo timer_ON			;   ,  
	
	rjmp alarm_NOT_1		;     (  )
	
timer_ON:

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;    
	lds temp1, day		; 
	lds temp2, day_count	;    
	
	sub temp1, temp2	;    -  
	brne alarm_NOT_0	;,    0
	
Everyday:
;------------------------------------------------------------------------------------------------
;        
	lds hex_01, degADC		;  
	lds temp_hex_01, degH		;  
	sub temp_hex_01, hex_01		;  
	brlo water_ON		;     ,   
	rjmp water_OFF		; ,  
water_ON:
	sbi portb, 1		;  
	ret
		
water_OFF:
	cbi portb, 1		;  
	clr temp		;   
	sts day_count, temp	;     
	ret	

alarm_NOT_0:
	cbi portb, 1		;  
	ret
	
alarm_NOT_1:
	cbi portb, 1		;  
	
	lds temp1, day		; 
	lds temp2, day_count	;    
	
	sub temp1, temp2	;    -  
	brne exit_alarm_NOT_1	;,    0
	
	clr temp		;   
	sts day_count, temp	;     
	ret
exit_alarm_NOT_1:
	ret			; 

           
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++           
check_time:
	ldi temp_hex_01, $80		;    
	ldi temp_hex_02, $51
	ldi temp_hex_03, $01
           
	sub temp_hex_01, hex_01
	sbc temp_hex_02, hex_02
	sbc temp_hex_03, hex_03
	brsh day_no_off		;    (  )
	
	clr temp		;   ,   
	sts clock_day, temp	;  
	sts clock_day+1, temp
	sts clock_day+2, temp
	
	lds temp, day_count	;  1  ,   
	inc temp		;   
	sts day_count, temp
	ret
	
day_no_off:
	sts clock_day, hex_01	;     
	sts clock_day+1, hex_02
	sts clock_day+2, hex_03
	ret
	
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++           
check_alarm:
	ldi temp_hex_01, $80		;    
	ldi temp_hex_02, $51
	ldi temp_hex_03, $01
           
	sub temp_hex_01, hex_01
	sbc temp_hex_02, hex_02
	sbc temp_hex_03, hex_03
	brsh day_no_off_	;    (  )
	
	clr temp		;   ,   
	sts clock_alarm, temp	;  
	sts clock_alarm+1, temp
	sts clock_alarm+2, temp
	ret
	
day_no_off_:
	sts clock_alarm, hex_01		;     
	sts clock_alarm+1, hex_02
	sts clock_alarm+2, hex_03
	
	lds temp_hex_01, on_minute	;    
	lds temp_hex_02, on_minute+1
	lds temp_hex_03, on_minute+2
	
	add hex_01, temp_hex_01		;    
	adc hex_02, temp_hex_02		;    
	adc hex_03, temp_hex_03
	
	sts alarm_off, hex_01		;     
	sts alarm_off+1, hex_02
	sts alarm_off+2, hex_03
		
	ret
	
;***********************************************************************************
check_timer:
	ldi temp_hex_01, $40		;    4  (  )
	ldi temp_hex_02, $38		;14400 
	ldi temp_hex_03, $00
           
	sub temp_hex_01, hex_01
	sbc temp_hex_02, hex_02
	sbc temp_hex_03, hex_03
	brsh day_no_off_2	;    (1   )
	
	clr temp		;   ,  1  
	sts on_minute, temp	;  
	sts on_minute+1, temp
	sts on_minute+2, temp
	ret
	
day_no_off_2:
	sts on_minute, hex_01		;    
	sts on_minute+1, hex_02
	sts on_minute+2, hex_03
	
	lds temp_hex_01, clock_alarm	;     
	lds temp_hex_02, clock_alarm+1
	lds temp_hex_03, clock_alarm+2
	
	add hex_01, temp_hex_01		;    
	adc hex_02, temp_hex_02		;    
	adc hex_03, temp_hex_03
	
	sts alarm_off, hex_01		;     
	sts alarm_off+1, hex_02
	sts alarm_off+2, hex_03

	ret
	
;***********************************************************************************
check_temper:
	ldi temp_hex_01, 50		;    
	lds hex_01, temper_cp
	sub temp_hex_01, hex_01
	brsh temper_no_off	;    (  50 )
	
	clr hex_01		;   ,     50 
	sts temper_cp, hex_01 
	
temper_no_off:
	sts temper_cp, hex_01
	ret
	
;**********************
; 
delen:
	ldi count, -1
SUBii:
	inc count
	sub hex_01, temp_hex_01	;lsb
	sbc hex_02, temp_hex_02
	sbc hex_03, temp_hex_03	;msb
	brsh SUBii           	;   > 0
	add hex_01, temp_hex_01	;lsb
	adc hex_02, temp_hex_02
	adc hex_03, temp_hex_03	;msb
ret

;*******************************************
;  8  
delen2:
	ldi count, -1
SUBii2:
	inc count
	sub hex_01, temp_hex_01	;lsb
	brsh SUBii2           	;   > 0
	add hex_01, temp_hex_01	;lsb
ret

	
;**********************************************************************************************
step_tune_clock_m:	
	lds hex_01, clock_day	;        
	lds hex_02, clock_day+1
	lds hex_03, clock_day+2
           
	ldi temp_hex_01, 60	;    60 sec
	clr temp_hex_02	;0
	clr temp_hex_03	;0
           
	add hex_01, temp_hex_01	;     1 
	adc hex_02, temp_hex_02
	adc hex_03, temp_hex_03
	
	sts clock_day, hex_01	;     
	sts clock_day+1, hex_02
	sts clock_day+2, hex_03
ret

step_tune_alarm_m:	
	lds hex_01, clock_alarm		;        
	lds hex_02, clock_alarm+1
	lds hex_03, clock_alarm+2
           
	ldi temp_hex_01, 60		;    60 sec
	clr temp_hex_02	;0
	clr temp_hex_03	;0
           
	add hex_01, temp_hex_01		;     1 
	adc hex_02, temp_hex_02
	adc hex_03, temp_hex_03
	
	sts clock_alarm, hex_01		;     
	sts clock_alarm+1, hex_02
	sts clock_alarm+2, hex_03
ret

step_tune_clock_h:	
	lds hex_01, clock_day	;        
	lds hex_02, clock_day+1
	lds hex_03, clock_day+2
           
	ldi temp_hex_01, $10	;    3600 sec
	ldi temp_hex_02, $0e
	ldi temp_hex_03, $00
           
	add hex_01, temp_hex_01	;     1 
	adc hex_02, temp_hex_02
	adc hex_03, temp_hex_03
	
	sts clock_day, hex_01	;     
	sts clock_day+1, hex_02
	sts clock_day+2, hex_03
ret

step_tune_alarm_h:	
	lds hex_01, clock_alarm	;        
	lds hex_02, clock_alarm+1
	lds hex_03, clock_alarm+2
           
	ldi temp_hex_01, $10	;    3600 sec
	ldi temp_hex_02, $0e
	ldi temp_hex_03, $00
           
	add hex_01, temp_hex_01	;     1 
	adc hex_02, temp_hex_02
	adc hex_03, temp_hex_03
	
	sts clock_alarm, hex_01	;     
	sts clock_alarm+1, hex_02
	sts clock_alarm+2, hex_03
ret

;*************************************************************************************
step_tune_timer_m:	
	lds hex_01, on_minute	;        
	lds hex_02, on_minute+1
	lds hex_03, on_minute+2
           
	ldi temp_hex_01, 60	;    60 sec
	clr temp_hex_02	;0
	clr temp_hex_03	;0
           
	add hex_01, temp_hex_01	;     1 
	adc hex_02, temp_hex_02
	adc hex_03, temp_hex_03
	
	sts on_minute, hex_01	;     
	sts on_minute+1, hex_02
	sts on_minute+2, hex_03
ret

step_tune_timer_h:
	lds hex_01, on_minute	;        
	lds hex_02, on_minute+1
	lds hex_03, on_minute+2
           
	ldi temp_hex_01, $58	;    600 sec
	ldi temp_hex_02, $02
	ldi temp_hex_03, $00
           
	add hex_01, temp_hex_01	;     10 
	adc hex_02, temp_hex_02
	adc hex_03, temp_hex_03
	
	sts on_minute, hex_01	;     
	sts on_minute+1, hex_02
	sts on_minute+2, hex_03
ret	

;***************************************************************************
step_tune_temper_m:	
	lds hex_01, temper_cp
	inc hex_01		;    1 
	sts temper_cp, hex_01
ret

step_tune_temper_h:
	lds hex_01, temper_cp
	ldi temp_hex_01, 5
	add hex_01, temp_hex_01	;    5 
	sts temper_cp, hex_01
ret

;***************************************************************************
step_tune_adc_m:	
	lds hex_01, degADC
	inc hex_01		;    
	sts degADC, hex_01
ret

step_tune_adc_h:
	lds hex_01, degADC
	ldi temp_hex_01, 10
	add hex_01, temp_hex_01	;    10 
	sts degADC, hex_01
ret

;****************************************************************************
step_tune_day:
	lds temp, day
	inc temp		;   1
	cpi temp, 7		;  6  -  
	breq reset_day
	rjmp day1
reset_day:
	clr temp
day1:
	sts day, temp
ret

;******************************
;   

dss1:
;-----   --------------------------------
;		rcall	t_sc		;   pull_up
		rcall	t_res    	; \		exist
		sbrc	bitmap,	$7
		rjmp	no_sen
		ldi	temp1,	$CC 	;  ROM-
		rcall	w_term		;  			write_byte
;-----    -------------------
st_cnv:		rcall	t_res		;				exist
		ldi	temp1,	$CC     ;  ROM-
		rcall	w_term		;  			write_byte
		ldi	temp1,	$44     ;   
		rcall	w_term		;  			write_byte
;		sbi	t_ddr,	t_sens  ;         ( pull_up)
;		sbi	t_port,	t_sens
no_sen:
		ret
;-----     750  ----------------

;-----   --------------------------------
dss2:
;		rcall	t_sc		;   pull_up
		rcall	t_res    	; \
		ldi	temp1,	$CC 	;  ROM-
		rcall	w_term		;  
		ldi	temp1,	$BE 	;  SRAM
		rcall	w_term		;  
		rcall	r_term	    	;    
		mov	temp2,	temp1
		rcall	r_term	    	;    
;-----   -------------------------
		cbr	bitmap,	$2
		mov	count,	temp2
		mov	smdl,	temp1
		andi	temp1,	$f	;    
		andi	temp2,	$f0	;   \ 
		or	temp2,	temp1	;   
		swap	temp2
		sbrs	smdl,	$7	;  
		rjmp	datapl
;-----   "-" ------------------------------
		sbr	bitmap,	$2
		swap	count
		andi	count,	$f0	;   
		ldi	temp1,	$0
		sub	temp1,	count
		mov	count,	temp1
		ldi	temp1,	$0
		sbc	temp1,	temp2
		mov	temp2,	temp1
		swap	count
		sbr	temp2,	$80
datapl:		sts	t_data,	temp2
		andi	count,	$f	;   
		sts	t_data+1, count	;     ""
		
		ret
;================================

bcd_convert:
;****************************************************
;		   :)
;****************************************************
		clr		bin_h
		lds		temp1,	t_data
		mov		cnt,	temp1
		andi	temp1,	$7f
		mov		bin_l,	temp1
		rcall	c2to10
		ldi		ZL,		low(t_asc2)
		ldi		ZH,		high(t_asc2)
;-----   -----------------------------------
		ldi		temp1,	$20
		sbrc	cnt,	$7
		ldi		temp1,	'-'		; 2D
		st		Z+,		temp1	;1
		mov		r7,		temp1
;-----   ----------------------------------
		ldi		temp1,	$20
		mov		temp2,	byte_1
		andi	temp2,	$f
		breq	d10_3
		mov		temp1,	temp2
		ori		temp1,	$30
d10_3:	st		Z+,		temp1		;2
;-----   --------------------------------
		ldi		temp1,	$20
		mov		temp2,	byte_0
		andi	temp2,	$f0
		brne	d10n2
		tst		byte_1
		breq	d10_2
d10n2:	mov		temp1,	temp2
		swap	temp1
		ori		temp1,	$30	;  ascii
d10_2:	st		Z+,		temp1		;3
		mov		r8,		temp1
;-----   -------------------------------
		mov		temp1,	byte_0
		andi	temp1,	$f
		ori		temp1,	$30	;  ascii
		st		z+,		temp1	;4
		mov		r9,		temp1
;-----    -----------------------
		ldi		temp1,	'.'
		st		Z+,		temp1	;5
;-----      --------------
		lds		count,	t_data+1
		tst		count
		breq	no_inc
		sbrc	bitmap,	$1
		inc		count
no_inc:	clr		temp1
		clr		temp2
binstr:	tst		count
		breq	binend
		subi	temp1,	$8f
		sbci	temp2,	$fd
		dec		count
		rjmp	binstr
binend:	mov		bin_l,	temp1
		mov		bin_h,	temp2
		rcall	c2to10
		mov		temp1,	byte_1
		andi	temp1,	$f0
		swap	temp1
		ori		temp1,	$30	;  ascii
		st		Z+,		temp1	;6
		mov		r10,	temp1
ret
;****************************************************

;******   *******************************
t_res:	rcall	t_sc
;---------- 480 uS ----------------------------------
		ldi		count,	t_480h
		ldi		smdl,	t_480l
		rcall	sm_d0
		rcall	t_cs
;---------- 70 uS -----------------------------------
		ldi		count,	t_70h
		ldi		smdl,	t_70l
		rcall	sm_d0
		sbr		bitmap,	$80
		sbis	t_pin,	t_sens
		cbr		bitmap,	$80
;---------- 410 uS ----------------------------------
		ldi		count,	t_410h
		ldi		smdl,	t_410l
		rcall	sm_d0
		ret
;******  ************************************
sm_del:	ldi		count,	$1
		nop
sm_d0:	dec		smdl
		brne	sm_d0
		dec		count
		brne	sm_d0
		ret
;******  1-Ware *******************************
w_term:	sec
        ror		temp1 
        rjmp	w_frst
;------   "temp"   -----------
w_bit:  lsr		temp1       
w_frst: breq	w_end
        brcc	w_bit0
;------  "1" -----------------------------------
		rcall	t_sc
		ldi	smdl,	t_6	; 6 uS
		rcall	sm_del
		rcall	t_cs
		ldi	count,	t_64h	; 64 uS
		ldi	smdl,	t_64l
		rcall	sm_d0
        	rjmp	w_bit
;------  "0" -----------------------------------
	w_bit0:	rcall	t_sc
		ldi	count,	t_60h	; 60 uS
		ldi	smdl,	t_60l
		rcall	sm_d0
		rcall	t_cs
		ldi	smdl,	t_10	; 10 uS
		rcall	sm_del
		rjmp	w_bit
		w_end:	ret
;******  1-Ware *******************************
	r_term:	ldi	cnt,	$8
	r_bit:	rcall	t_sc
		ldi	smdl,	t_6	; 6 uS
		rcall	sm_del
		rcall	t_cs
		ldi	smdl,	t_9	; 9 uS
		rcall	sm_del
		clc
		sbic	t_pin,	t_sens
		sec
		ror	temp1
		ldi	count,	t_55h	; 55 uS
		ldi	smdl,	t_55l
		rcall	sm_d0
		dec	cnt
		brne	r_bit
		ret
;******    pull-up 1-Ware *********
	t_sc:
		sbi	t_ddr,	t_sens
		cbi	t_port,	t_sens
		ret
;----------------------------------------------------
	t_cs:
		cbi	t_ddr,	t_sens
		sbi	t_port,	t_sens
		ret
;****************************************************
; bin2BCD16
;****************************************************
	c2to10:
		ldi	count,	$10
		clr	byte_0
		clr	byte_1
		clr	byte_2
		clr	ZH
	loop_b:
		lsl	bin_l
		rol	bin_h
		rol	byte_0
		rol	byte_1
		rol	byte_2
		dec	count
		brne	nm1
		ret
	nm1:
		ldi	ZL,	$5
	nm2:
		ld	smdl,	-Z
		ldi	temp1,	$03
		add	smdl,	temp1
		sbrc	smdl,	3
		st	Z,	smdl
		ld	smdl,	Z
		ldi	temp1,	$30
		add	smdl,	temp1
		sbrc	smdl,	7
		st	Z,	smdl
		cpi	ZL,	$2
		brne	nm2
		rjmp	loop_b
;***************************************************

;===================================================
;   
convertK:
	clr hex_01
	ldi temp,10		;  
tens_plus:
	dec r8
	brmi aaa
	add hex_01,temp
	rjmp tens_plus
aaa:
	add hex_01, r9		;  
	sts temper_hex, hex_01	;    
ret

;=======================================================================================
EERead:	
	sbic 	EECR,EEWE		;      .
	rjmp	EERead			;    .
	out 	EEARL, temp1		;    
;	out  	EEARH, temp2 		;     
	sbi 	EECR,EERE 		;   
	in 	temp, EEDR 		;     
	ret
	
;===============================================================================================
EEWrite:	
	sbic	EECR,EEWE		;     .   
	rjmp	EEWrite 		;        EEWE
 
	cli				;   .
	out 	EEARL,temp1 		;    
;	out 	EEARH,temp2  		;     
	out 	EEDR,temp 		;   ,    
 
	sbi 	EECR,EEMWE		;  
	sbi 	EECR,EEWE		;  
 
	sei 				;  
	ret 				;   

;*******************************************************************************************	
save_eep:
	ldi temp1, low(setup)		;   68h
;	ldi temp2, high(setup)
	ldi temp, 1
	sts setup, temp		;     (1)
	rcall EEWrite		;  1   0 
	
	ldi ZL, low(setup)	;68h      
Flush2:	
	ld temp, -Z		;       
	mov temp1, ZL		;        
	rcall EEWrite		;    0 
	cpi ZL, low(clock_alarm);    ?
	brne Flush2		; ?  !
ret

;*************************************************************
;        
Decoder:
	ldi 	ZL, LOW(DcMatrix*2)   
	ldi 	ZH, HIGH(DcMatrix*2)
	ldi	temp1, 0	;high
	add 	ZL, temp                       
   	adc 	ZH, temp1				
    	lpm 	temp, Z 	;                      
ret

;===============================================================
serial:
	out portd, temp		; 
ret

;=================================================
;   
display_led_time:
	lds 	temp, time
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	lds 	temp, time+1
	rcall	decoder
	rcall	serial
	cbi	portd, 2	; 
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, time+2
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	lds 	temp, time+3
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4  
ret

display_time_sec:
	lds 	temp, time+2
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	lds 	temp, time+3
	rcall	decoder
	rcall	serial
	cbi	portd, 2	; 
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, time+4
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	lds 	temp, time+5
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4  
ret

display_led_temp:
	lds	temp, chan_1
	cpi	temp, $2d
	breq	minus_led
	rjmp	miss_1_led
minus_led:	
	ldi	temp, 14	;   
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
miss_1_led:
	lds 	temp, chan_1+1
	cpi	temp, 0
	brne	write_num
	rjmp	miss_num2
write_num:	
	rcall	decoder
	rcall	serial
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2
miss_num2:	
	lds 	temp, chan_1+2
	rcall	decoder
	rcall	serial
	cbi	portd, 2	; 
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	lds 	temp, chan_1+3
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4  
ret

display_led_adc:
	ldi	temp, 10	;  
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	lds 	temp, ADC_display
	rcall	decoder
	rcall	serial
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, ADC_display+1
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	lds 	temp, ADC_display+2
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_day_day:
	ldi	temp, 1		;1
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	ldi	temp, 14	;  
	rcall	decoder
	rcall	serial
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, day_count
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3
ret

display_led_time_set_M:
	ldi	temp, 1		;menu #1
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_time_set:
	lds 	temp, time
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	lds 	temp, time+1
	rcall	decoder
	rcall	serial
	cbi	portd, 2	; 
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, time+2
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	lds 	temp, time+3
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_alarm_set_M:
	ldi	temp, 2		;menu #2
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret
	

display_led_alarm_set:
	lds 	temp, alarm
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	lds 	temp, alarm+1
	rcall	decoder
	rcall	serial
	cbi	portd, 2	; 
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, alarm+2
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	lds 	temp, alarm+3
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_timer_set_M:
	ldi	temp, 3		;menu #3
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_timer_set:
;	lds 	temp, timer
;	rcall	decoder
;	rcall	serial
;	sbi	portc,2		;  1
;	rcall 	delay_led
;	cbi	portc,2		;  1
	
	lds 	temp, timer+1
	rcall	decoder
	rcall	serial
	cbi	portd, 2	; 
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, timer+2
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	lds 	temp, timer+3
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_temp_set_M:
	ldi	temp, 4		;menu #4
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_temp_set:
	ldi	temp, 10	;  
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	lds 	temp, temper
	rcall	decoder
	rcall	serial
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, temper+1
	rcall	decoder
	rcall	serial
	cbi	portd, 2	; 
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	ldi	temp, 0		;  0
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_adc_set_M:
	ldi	temp, 5		;menu #5
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_adc_set:
	ldi	temp, 10	;  
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	lds 	temp, ADC_displaySet
	rcall	decoder
	rcall	serial
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, ADC_displaySet+1
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	lds 	temp, ADC_displaySet+2
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_day_M:
	ldi	temp, 6		;menu #6
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret

display_led_day_set:
	ldi	temp, 1		;1
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	ldi	temp, 14	;  
	rcall	decoder
	rcall	serial
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	lds 	temp, day
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3
ret

display_led_save:
	ldi	temp, 5		;S
	rcall	decoder
	rcall	serial
	sbi	portc,2		;  1
	rcall 	delay_led
	cbi	portc,2		;  1
	
	ldi	temp, 11	;A
	rcall	decoder
	rcall	serial
	sbi	portc,3		;  2
	rcall 	delay_led
	cbi	portc,3		;  2

	ldi	temp, 12	;V
	rcall	decoder
	rcall	serial
	sbi	portc,4		;  3
	rcall 	delay_led
	cbi	portc,4		;  3

	ldi	temp, 13	;E
	rcall	decoder
	rcall	serial
	sbi	portc,5		;  4
	rcall 	delay_led
	cbi	portc,5		;  4 
ret
	

;=================================================
;      2 ms
delay_led:
; Generated by delay loop calculator
; at http://www.bretmulvey.com/avrdelay.html

    ldi  temp, 11
    ldi  temp1, 99
L1: dec  temp1
    brne L1
    dec  temp
    brne L1
ret
	
    



	
	
	
	
	
	
		

