; 16.002 
;    PB7
;   455.000 

.include "tn2313def.inc"

.CSEG 
.org 0
		
	rjmp	RESET

RESET:
;  
	CLR     R30
	LDI     R31,0x18          ; 0x18 = 0b00011000 = 24
	in      R26,0x34
	ANDI    R26,0xF7          ; 0xF7 = 0b11110111 = 247
	OUT     MCUSR,R26
	OUT     WDTCR,R31	; 
	OUT     WDTCR,R30

; 	
	LDI     R30,0x00          ; 0x00 = 0b00000000 = 0
	OUT     PORTB,R30
	LDI     R30,0x80          ; 0x80 = 0b10000000 = 128
	OUT     DDRB,R30
	LDI     R30,0x00          ; 0x00 = 0b00000000 = 0
	OUT     PORTD,R30
	LDI     R30,0x7E          ; 0x7E = 0b01111110 = 126
	OUT     DDRD,R30	;6     
	
; UART	
	LDI     R30,0x02          ; 0x02 = 0b00000010 = 2
	OUT     UCSRA,R30	;0xB Bit 1  U2X: Double the USART Transmission Speed
	
	LDI     R30,0x10          ; 0x10 = 0b00010000 = 16
	OUT     UCSRB,R30	;0xA Bit 4  RXEN: Receiver Enable
	
	LDI     R30,0x06          ; 0x06 = 0b00000110 = 6
	OUT     UCSRC,R30	;0x3 Stop Bit = 1, frame = 8 Bit
	
	LDI     R30,0x00          ; 0x00 = 0b00000000 = 0
	OUT     UBRRH,R30	;0x2
	LDI     R30,16          ; 16
	OUT     UBRRL,R30	;0x9 speed 115.2k fosc = 16.0000 MHz

	CLR     R27
	CLR     R28
	CLR     R29
	CLR     R30

;F=455.000 khz	-   
	LDI     R23,0x98          ; 0x98 = 0b10011000 = 152 Low
	LDI     R24,0x93          ; 0x93 = 0b10010011 = 147
	LDI     R25,0x3B          ; 0x3B = 0b00111011 = 59
	LDI     R26,0x3A          ; 0x3A = 0b00111010 = 58 High
	
;         UART
Loop:	
A_4:	
	ADD     R27,R23		;Low
	ADC     R28,R24
	ADC     R29,R25
	ADC     R30,R26		;High
	OUT     PORTB,R30
	SBIS    UCSRA,RXC		;0x0B 0b00000111
	RJMP    A_4           ; Destination: 0x00006D
	in      R2,UDR		;   

A_5:	
	ADD     R27,R23		;Low
	ADC     R28,R24
	ADC     R29,R25
	ADC     R30,R26		;High
	OUT     PORTB,R30
	SBIS    UCSRA,RXC		;0xB
	RJMP    A_5           ; Destination: 0x000075
	in      R5,UDR		;  -      

A_6:	
	ADD     R27,R23		;Low
	ADC     R28,R24
	ADC     R29,R25
	ADC     R30,R26		;High
	OUT     PORTB,R30
	SBIS    UCSRA,RXC		;0xB
	RJMP    A_6           ; Destination: 0x00007D
	in      R4,UDR		;  -     

A_7:	
	ADD     R27,R23		;Low
	ADC     R28,R24
	ADC     R29,R25
	ADC     R30,R26		;High
	OUT     PORTB,R30
	SBIS    UCSRA,RXC		;0xB
	RJMP    A_7           ; Destination: 0x000085
	in      R7,UDR		;  -     

A_8:	
	ADD     R27,R23		;Low
	ADC     R28,R24
	ADC     R29,R25
	ADC     R30,R26		;High
	OUT     PORTB,R30
	SBIS    UCSRA,RXC		;0xB
	RJMP    A_8           ; Destination: 0x00008D
	in      R26,UDR		;  -      

;  ,    
	ADD     R27,R23		;Low
	ADC     R28,R24
	ADC     R29,R25
	ADC     R30,R26		;High
	OUT     PORTB,R30
	
	MOV     R23,R5		;Low
	MOV     R24,R4
	MOV     R25,R7		;High	
	
	ADD     R27,R23		;Low         
	ADC     R28,R24
	ADC     R29,R25
	ADC     R30,R26		;High
	OUT     PORTB,R30
	
	OUT     PORTD,R2	;    

	rjmp	Loop
